<?php
/**
 * Class to Build the Slider Block.
 *
 * @package Kadence Blocks
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class to Build the Slider Block.
 *
 * @category class
 */
class Kadence_Blocks_Pro_Slider_Block extends Kadence_Blocks_Pro_Abstract_Block {

	/**
	 * Instance of this class
	 *
	 * @var null
	 */
	private static $instance = null;

	/**
	 * Block name within this namespace.
	 *
	 * @var string
	 */
	protected $block_name = 'slider';

	/**
	 * Block determines in scripts need to be loaded for block.
	 *
	 * @var string
	 */
	protected $has_script = true;

	/**
	 * Instance Control
	 */
	public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Builds CSS for block.
	 *
	 * @param array $attributes the blocks attributes.
	 * @param Kadence_Blocks_CSS $css the css class for blocks.
	 * @param string $unique_id the blocks attr ID.
	 * @param string $unique_style_id the blocks alternate ID for queries.
	 */
	public function build_css( $attributes, $css, $unique_id, $unique_style_id ) {

		$this->enqueue_script( 'kadence-blocks-pro-slider-init' );
		$this->enqueue_style( 'kadence-kb-splide' );

		$css->set_style_id( 'kb-' . $this->block_name . $unique_style_id );

		$margin_unit = ( isset( $attributes['marginUnit'] ) && ! empty( $attributes['marginUnit'] ) ? $attributes['marginUnit'] : 'px' );
		$padding_unit = ( isset( $attributes['paddingUnit'] ) && ! empty( $attributes['paddingUnit'] ) ? $attributes['paddingUnit'] : 'px' );
		$height_unit = ( isset( $attributes['heightUnit'] ) && ! empty( $attributes['heightUnit'] ) ? $attributes['heightUnit'] : 'px' );

		if (isset($attributes['heightType']) && 'fixed' === $attributes['heightType'] && isset($attributes['minHeight']) && is_array($attributes['minHeight']) && !empty($attributes['minHeight'][0])) {
			$css->set_selector('.kb-advanced-slider-' . $unique_id . ' .kb-slider-size-fixed .kb-advanced-slide-inner-wrap');
			$css->add_property('min-height', $attributes['minHeight'][0] . $height_unit);

			if (!empty($attributes['minHeight'][1])) {
				$css->set_media_state('tablet');
				$css->add_property('min-height', $attributes['minHeight'][1] . $height_unit);
			}

			if (!empty($attributes['minHeight'][2])) {
				$css->set_media_state('mobile');
				$css->add_property('min-height', $attributes['minHeight'][2] . $height_unit);
			}
		}
		if (isset($attributes['maxWidth']) && is_array($attributes['maxWidth']) && !empty($attributes['maxWidth'][0])) {
			$css->set_selector('.kb-advanced-slider-' . $unique_id . ' .kb-advanced-slide-inner');
			$css->add_property('max-width', $attributes['maxWidth'][0] . (isset($attributes['widthUnit']) && !empty($attributes['widthUnit']) ? $attributes['widthUnit'] : 'px'));

			if (!empty($attributes['maxWidth'][1])) {
				$css->set_media_state('tablet');
				$css->add_property('max-width', $attributes['maxWidth'][1] . (isset($attributes['widthUnit']) && !empty($attributes['widthUnit']) ? $attributes['widthUnit'] : 'px'));
			}

			if (!empty($attributes['maxWidth'][2])) {
				$css->set_media_state('mobile');
				$css->add_property('max-width', $attributes['maxWidth'][2] . (isset($attributes['widthUnit']) && !empty($attributes['widthUnit']) ? $attributes['widthUnit'] : 'px'));
			}
		}

		$css->set_selector('.kb-advanced-slider-' . $unique_id . ' .kb-advanced-slide-inner-wrap');
		$padding = array(
			'padding' => !empty( $attributes['padding'][0]['desk'] ) ? $attributes['padding'][0]['desk'] : [ '', '', '', '' ],
			'tabletPadding' => !empty( $attributes['padding'][0]['tablet'] ) ? $attributes['padding'][0]['tablet'] : [ '', '', '', '' ],
			'mobilePadding' => !empty( $attributes['padding'][0]['mobile'] ) ? $attributes['padding'][0]['mobile'] : [ '', '', '', '' ],
			'paddingType' => $padding_unit
		);
		$css->render_measure_output( $padding, 'padding', 'padding' );

		$css->set_selector('.kb-advanced-slider-' . $unique_id);
		$margin = array(
			'margin' => !empty( $attributes['margin'][0]['desk'] ) ? $attributes['margin'][0]['desk'] : [ '', '', '', '' ],
			'tabletMargin' => !empty( $attributes['margin'][0]['tablet'] ) ? $attributes['margin'][0]['tablet'] : [ '', '', '', '' ],
			'mobileMargin' => !empty( $attributes['margin'][0]['mobile'] ) ? $attributes['margin'][0]['mobile'] : [ '', '', '', '' ],
			'marginType' => $margin_unit
		);
		$css->render_measure_output( $margin, 'margin', 'margin' );

		return $css->css_output();
	}

	/**
	 * Registers scripts and styles.
	 */
	public function register_scripts() {

		// Skip calling parent because this block does not have a dedicated CSS file.
		parent::register_scripts();

		// If in the backend, bail out.
		if ( is_admin() ) {
			return;
		}
		if ( apply_filters( 'kadence_blocks_check_if_rest', false ) && kadence_blocks_is_rest() ) {
			return;
		}
		wp_register_script( 'kad-splide', KBP_URL . 'includes/assets/js/splide.min.js', array(), KBP_VERSION, true );
		wp_register_script( 'kadence-blocks-pro-slider-init', KBP_URL . 'includes/assets/js/kb-splide-slider-init.min.js', array( 'kad-splide' ), KBP_VERSION, true );
		wp_register_style( 'kadence-kb-splide', KBP_URL . 'includes/assets/css/kadence-splide.min.css', array(), KBP_VERSION );
	}
}

Kadence_Blocks_Pro_Slider_Block::get_instance();
